<?php

class MainController extends Controller
{
	//public $layout = '//layouts/column2';
	public $layout = 'teacher';
	public $defaultAction = 'index';
	public $menu = null;

	public function init()
	{
		if(isset(Yii::app()->user->role) && Yii::app()->user->role == 'teacher')
		{
			$this->menu = array(
				array('url'=>array('/teacher/main/index'), 'label'=>'Lekcje'),
				array('url'=>array('/teacher/main/classes'), 'label'=>'Klasy'),
				array('url'=>array('/teacher/main/statistics'), 'label'=>'Statystyki'),
				array('url'=>array('/teacher/main/account'), 'label'=>'Moje konto'),
				array('url'=>array('/teacher/main/documents'), 'label'=>'Wypełnione formularze'),
				array('url'=>array('/teacher/main/inactiveStudents'), 'label'=>'Nieaktywni użytkownicy'),
				array('url'=>array('/teacher/main/tenders'), 'label'=>'Przetargi')
			);
		}
	}

	public function actions()
	{
		return array(
			'form'=>'application.modules.teacher.controllers.main.FormAction',
			'printOrder'=>'application.modules.teacher.controllers.main.PrintOrderAction',
		);
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow users to perform actions
				'actions'=>array('error','login','logout'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform actions
				'actions'=>array('index','lessons','startLesson','classes','class','account',
						'registrationStart','student','form','getFormImage','inactiveStudents',
						'formStatusChange','company','documents','activateGroups','rejectGroups',
						'statistics','imageTest','getMessages','tenders','acceptTender','printOrder',
						'updateOrder','markStudentPresence','changeStudentPassword','stopClass','resetTestClass',
						'cancelLesson'),
				'roles'=>array('teacher')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex()
	{
		//zamienić na getState('adminId')
		$adminId = Yii::app()->user->id;

		Przetarg::initialize($adminId);

		$lessonsDataProvider = Lekcja::model()->getAsTables($adminId);

		$previousClassId = -1;
		$currentData = array();
		$lessonsDataProviders = array();
		$classNames = array();
		$previousClassName = '';
		
		$aktywneTury = array();

		//rozdzielanie wyników zapytania na poszczególne tabele
		foreach($lessonsDataProvider->data as $i=>$lesson)
		{
			if($previousClassId != $lesson['idKlasy'] && $i>0)
			{
				$classNames[$previousClassId] = $previousClassName;
				$lessonsDataProviders[$previousClassId] = new CArrayDataProvider($currentData, array(
					'pagination'=>false,
					'keyField'=>'rownum'
				));
				$currentData = array();
			}

			$currentData[] = $lesson;
			$previousClassId = $lesson['idKlasy'];
			$previousClassName = $lesson['nazwa'];
		}

		$classNames[$previousClassId] = $previousClassName;
		
		$classIndexes = array_keys($classNames);

		if(count($classIndexes))
		{
			$aktywneTuryModels = Tura::model()->findAllBySql('SELECT * FROM "Tura" WHERE "idKlasy" IN ('.implode(',',$classIndexes).') AND "czasRozpoczecia" IS NOT NULL AND "czasZakonczenia" IS NOT NULL AND "czasZakonczenia" > SYSDATE');

			foreach($aktywneTuryModels as $i=>$aktywna)
			{
				$cancelAllowed = $aktywna->checkIfCancelAllowed();
				
				if($cancelAllowed)
					$aktywneTury[$aktywna->idKlasy] = $aktywna->idLekcji;
				
			}
		}

		$lessonsDataProviders[$previousClassId] = new CArrayDataProvider($currentData, array(
			'pagination'=>false,
			'keyField'=>'rownum'
		));
		$admin = Admin::model()->findByPk($adminId);
		$testClass = $admin->testowaKlasa[0];
		$testTime = $admin->czasTestowejLekcji;

		$this->render('index', array(
			'lessonsDataProviders'=>$lessonsDataProviders,
			'classNames'=>$classNames,
			'testClass'=>$testClass,
			'maxLessons' => ParametryGry::getValue('ILOSC_AKTYWNYCH_LEKCJI'),
			'testLessonTime'=> $testTime,
			'activeLessons'=>$aktywneTury
		));
	}

	public function actionLessons($id)
	{
		$classModel = Klasa::getTeacherClass($id);

		if (empty($classModel))
			throw new CHttpException(404, 'Brak dostępu do klasy.');

		$dataProvider = Lekcja::model()->getByClass($id);

		$admin = Admin::model()->findByPk(Yii::app()->user->id);
		$testTime = $admin->czasTestowejLekcji;
		
		$activeLessonId = Yii::app()->db->createCommand('SELECT "idLekcji" FROM "Tura" WHERE "idKlasy" = :idKlasy AND "czasRozpoczecia" IS NOT NULL AND "czasZakonczenia" IS NOT NULL AND "czasZakonczenia" > SYSDATE')->queryScalar(array(':idKlasy'=>$id));
		
		$turaModel = Tura::model()->findBySql('SELECT * FROM "Tura" WHERE "idKlasy" = :idKlasy AND "czasRozpoczecia" IS NOT NULL AND "czasZakonczenia" IS NOT NULL AND "czasZakonczenia" > SYSDATE', array(':idKlasy'=>$id));
		
		$cancelAllowed = false;
		if($turaModel !== null)
			$cancelAllowed = $turaModel->checkIfCancelAllowed();

		$this->render('lessons',array(
			'dataProvider'=>$dataProvider,
			'classModel'=>$classModel,
			'maxLessons' => ParametryGry::getValue('ILOSC_AKTYWNYCH_LEKCJI'),
			'testLessonTime'=> $testTime,
			'activeLessonId'=>$turaModel !== null ? $turaModel->idLekcji : false,
			'classId'=>$id,
			'cancelAllowed'=>$cancelAllowed
		));
	}

	public function actionStartLesson($id, $classId, $durationTime = null)
	{
		if(!Lekcja::model()->startAllowed(Yii::app()->user->id, $id, $classId))
			throw new CHttpException(404,'Nie można znaleźć podanej strony.');

		$classModel = Klasa::model()->findByPk($classId);
		$lessonModel = Lekcja::model()->findByPk($id);

		if(isset($_POST['accept']))
		{
			if(!empty($durationTime))
			{
				$lessonDuration = intval($durationTime);
				$admin = Admin::model()->findByPk(Yii::app()->user->id);
				$admin->czasTestowejLekcji = $lessonDuration;
				$admin->save(false);
			}
			else
				$lessonDuration = ParametryGry::model()->findByAttributes(array('nazwa'=>'CZAS_TRWANIA_LEKCJI'))->wartosc;

			Tura::model()->startNewRound($lessonDuration, $id, $classId);
			if($lessonModel->order==1)
			{
				$classModel->czasRozpoczeciaRejestracji = new CDbExpression('SYSDATE');
				$classModel->save(false);
			}

			Yii::app()->user->setFlash('lessonStarted', 'Lekcja została rozpoczęta.');

			$this->redirect(array('lessons','id'=>$classId));
		}

		$this->render('startLesson',array(
			'lessonModel'=>$lessonModel,
			'classModel'=>$classModel
		));
	}

	public function actionStopClass($id, $classId)
	{
		$sql = 'UPDATE "Tura" SET "czasZakonczenia" = SYSDATE WHERE "idLekcji" = :id AND "idKlasy" = :classId';
		Yii::app()->db->createCommand($sql)->execute(array(':id'=>$id, ':classId'=> $classId));

		$this->redirect(array('lessons','id'=>$classId));
	}

	public function actionResetTestClass()
	{
		Klasa::createTeachersTestClass();

		$this->redirect(array('index'));
	}

	public function actionClasses()
	{
		Przetarg::initialize(Yii::app()->user->id);

		$classes = new CActiveDataProvider('Klasa',array(
			'criteria'=>array(
				'join' => 'left join "AdminKlasy" ak on ak."idKlasy" = "t"."id"',
				'condition' => 'ak."idAdmina" = :teacherId and ("t"."czyTestowa" = 0 OR "t"."czyTestowa" = 1 AND "t"."id" = (SELECT MAX("id") FROM "Klasa" LEFT JOIN "AdminKlasy" ON "AdminKlasy"."idKlasy" = "Klasa"."id" WHERE "AdminKlasy"."idAdmina" = :teacherId AND "Klasa"."czyTestowa" = 1))',
				'params' => array(':teacherId' => Yii::app()->user->id),
				'order' => '"t"."nazwa"',
				'with' => array('szkola')
			),
			'pagination'=>false
		));

		$this->render('classes',array(
			'classes'=>$classes,
		));
	}

	public function actionClass($id)
	{
		Przetarg::initialize(Yii::app()->user->id);

		$class = Klasa::getTeacherClass($id);

		if (empty($class))
			throw new CHttpException(404, 'Brak dostępu do klasy.');

		$students = new Uzytkownik('search');
		if (isset($_GET['Uzytkownik']))
			$students->attributes = $_GET['Uzytkownik'];
		$students->idKlasy = $id;

		$tura = Tura::getTuraForClass($id);
		if (empty($tura))
			$absence = array();
		else
			$absence = Yii::app()->db->createCommand('
				select "idUzytkownika" from "UzytkownikObecnosc"
				where "obecny" = 0 and "idTury" = :idTury
			')->queryColumn(array(':idTury' => $tura->id));

		$companies = new Firma('search');
		if (isset($_GET['Firma']))
			$companies->attributes = $_GET['Firma'];
		$companies->idKlasy = $id;

		$this->render('class',array(
			'students'=>$students,
			'companies'=>$companies,
			'class'=>$class,
			'absence'=>$absence,
			'tura'=>$tura
		));
	}

	public function actionRegistrationStart($id)
	{
		$class = Klasa::getTeacherClass($id);

		if (empty($class))
			throw new CHttpException(404, 'Brak dostępu do klasy.');

		if(isset($_POST['accept']))
		{
			$class->czasRozpoczeciaRejestracji = new CDbExpression('SYSDATE');
			$class->save(false);
			$registrationEndDate = date("Y-m-d H:i:s", strtotime('+'.ParametryGry::model()->find('"nazwa"=\'CZAS_NA_REJESTRACJE\'')->wartosc.' minutes',strtotime($class->getRegistrationTime())));
			Yii::app()->user->setFlash('registartionStarted','Rejestracja dla klasy '.$class->nazwa.' została rozpoczęta i będzie trwać do '.$registrationEndDate);
			$this->redirect(array('class', 'id'=>$id));
		}

		$this->render('registrationStart', array(
			'class'=>$class
		));
	}

	public function actionError()
	{
	    if($error = Yii::app()->errorHandler->error)
	    {
	    	if(Yii::app()->request->isAjaxRequest)
	    		echo $error['message'];
	    	else
	        	$this->render('error', $error);
	    }
	}

	public function actionLogin()
	{
		if(!Yii::app()->user->isGuest)
			Yii::app()->user->logout();

		$this->redirect(array('/administration/main/login'));
	}

	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(array('/administration/main/login'));
	}


        public function actionChangeStudentPassword($id)
	{
             $model = Uzytkownik::getTeachersStudent($id);
             $currentPassword = $model->haslo;

             if(isset($_POST['Uzytkownik']))
             {
             		$model->attributes = $_POST['Uzytkownik'];

			if($model->validate())
			{
				if(!empty($model->haslo))
					$model->haslo = hash('sha1', $model->haslo);
				else
					$model->haslo = $currentPassword;
				$model->save(false);

                                Yii::app()->user->setFlash('accountUpdated', 'Hasło zostało pomyślnie zaktualizowane.');

                                $this->redirect(array('main/changeStudentPassword','id'=>$id));
			}
                }
                else
                {
	                $model->haslo = '';
			$model->hasloPowtorzone = '';
			$this->render('changeStudentPassword',array('model'=>$model));
                }
        }

	public function actionAccount()
	{
		$model = Admin::model()->findByPk(Yii::app()->user->id);
		$currentPassword = $model->haslo;


		if(isset($_POST['Admin']))
		{
			$model->attributes = $_POST['Admin'];

			if($model->validate())
			{
				if(!empty($model->haslo))
					$model->haslo = hash('sha1', $model->haslo);
				else
					$model->haslo = $currentPassword;

				$model->save(false);
				Yii::app()->user->setFlash('accountUpdated', 'Konto zostało pomyślnie zaktualizowane.');
				$this->redirect(array('account'));
			}
		}
		$model->haslo = '';
		$model->hasloPowtorzone = '';

		$this->render('account',array('model'=>$model));
	}

	public function actionDocuments()
	{
		$classes = Admin::model()->findByPk(Yii::app()->user->id)->klasyZTestowa;
		$documentsToAccept = Admin::getDocumentsToAccept();

		$this->render('documents',array(
			'classes'=>$classes,
			'documentsToAccept'=>$documentsToAccept,
		));
	}

	public function actionInactiveStudents()
	{
		$classes = Admin::model()->with('klasyZTestowa')->findByPk(Yii::app()->user->id)->klasyZTestowa;

		$this->render('inactiveStudents',array(
			'classes'=>$classes,
		));
	}

	public function actionActivateGroups()
	{
		$companiesToActivation = array();
		$companiesToAssignment = array();

		foreach($_POST['Group'] as $id=>$group)
		{
			if(!isset($group['selected']))
				continue;
			if($group['assign'] == 'newCompany')
				$companiesToActivation[] = Yii::app()->db->quoteValue($id);
			else
				$companiesToAssignment[] = Yii::app()->db->quoteValue($id);
		}

		if(!empty($companiesToActivation))
		{
			$sql = 'UPDATE "Firma"
				SET "status" = '.Firma::COMPANY_STATUS_ACTIVE.'
				WHERE "id" IN ('.implode(',',$companiesToActivation).') AND "idKlasy" IN (SELECT t2."idKlasy"
										FROM "AdminKlasy" t2
										WHERE t2."idAdmina" = '.Yii::app()->user->id.')';

			Yii::app()->db->createCommand($sql)->execute();
		}

		if(!empty($companiesToAssignment) || !empty($companiesToActivation))
		{
			$sql = 'UPDATE "Uzytkownik" t
				SET t."status" = '.Uzytkownik::USER_STATUS_ACTIVE.'
				WHERE t."idFirmy" IN ('.implode(',',array_merge($companiesToActivation,$companiesToAssignment)).') AND t."idKlasy" IN (SELECT t2."idKlasy"
															FROM "AdminKlasy" t2
															WHERE t2."idAdmina" = '.Yii::app()->user->id.')';

			Yii::app()->db->createCommand($sql)->execute();
		}

		foreach($companiesToAssignment as $companyId)
		{
			$sql = 'UPDATE "Uzytkownik" t
				SET t."status" = '.Uzytkownik::USER_STATUS_ACTIVE.', t."idFirmy" = :existingCompanyId
				WHERE t."id" IN (SELECT t2."id" FROM "Uzytkownik" t2 WHERE t2."idFirmy"=:companyToAssignment)';

			Yii::app()->db->createCommand($sql)->execute(array(':existingCompanyId'=>$_POST['Group'][$companyId]['existingCompany'], ':companyToAssignment'=>$companyId));

			$sql = 'DELETE FROM "DziedzinaFirmy" WHERE "idFirmy" = :companyToAssignment';

			Yii::app()->db->createCommand($sql)->execute(array(':companyToAssignment'=>$companyId));

			$sql = 'DELETE FROM "Firma"
				WHERE "id" = :companyToAssignment AND "status" = '.Firma::COMPANY_STATUS_INACTIVE;

			Yii::app()->db->createCommand($sql)->execute(array(':companyToAssignment'=>$companyId));
		}

		if(count($companiesToActivation))
			Yii::app()->user->setFlash('groupActivated','Użytkownicy zostali aktywowani.');

		$this->redirect(Yii::app()->request->getUrlReferrer());
	}

	public function actionRejectGroups(array $companyIds)
	{
		if(count($companyIds))
		{
			$ids = Firma::getTeachersBusinessIds($companyIds);

			foreach ($ids as $id)
				$ids[$id] = Yii::app()->db->quoteValue($id);
			$companyIds = join(',', $ids);

			if (!count($ids))
				throw new CHttpException(404, 'Brak uprawnień dla firm.');

			$sql = 'DELETE "DziedzinaUzytkownika"
				WHERE "idUzytkownika" IN (SELECT t."id" FROM "Uzytkownik" t WHERE t."idFirmy" IN ('.$companyIds.'))';

			Yii::app()->db->createCommand($sql)->execute();

			$sql = 'DELETE "Uzytkownik" t
				WHERE t."status" = '.Uzytkownik::USER_STATUS_INACTIVE.' AND t."idFirmy" IN ('.$companyIds.') AND t."idKlasy" IN (SELECT t2."idKlasy"
										FROM "AdminKlasy" t2
										WHERE t2."idAdmina" = '.Yii::app()->user->id.')';

			Yii::app()->db->createCommand($sql)->execute();

			$sql = 'DELETE "DziedzinaFirmy"
				WHERE "idFirmy" IN ('.$companyIds.')';

			Yii::app()->db->createCommand($sql)->execute();

			$sql = 'DELETE "Firma"
				WHERE "status" = '.Firma::COMPANY_STATUS_INACTIVE.' AND "id" IN ('.$companyIds.') AND "idKlasy" IN (SELECT t2."idKlasy"
										FROM "AdminKlasy" t2
										WHERE t2."idAdmina" = '.Yii::app()->user->id.')';

			Yii::app()->db->createCommand($sql)->execute();

			Yii::app()->user->setFlash('groupActivated','Uzytkownicy zostali odrzuceni.');
		}

		$this->redirect(Yii::app()->request->getUrlReferrer());
	}

	public function activateStudent($id)
	{
		$model = Uzytkownik::getTeachersStudent($id);

		if (empty($model))
			throw new CHttpException(404, 'Brak dostępu do ucznia.');

		$model->status = Uzytkownik::USER_STATUS_ACTIVE;
		$model->save(false);
	}

	public function removeStudent()
	{

	}

	public function actionStudent($id)
	{
		$model = Uzytkownik::getTeachersStudent($id);

		if (empty($model))
			throw new CHttpException(404, 'Brak dostępu do ucznia.');

		$akcjeArr = Akcja::model()->with(array('lekcja'))->findAllBySql('
			select level "poziom", "t".*, "au"."dataWykonania" from "Akcja" "t"
			left join "AkcjaUzytkownika" "au" ON "au"."idAkcji" = "t"."id" and "au"."idUzytkownika" = :idUcznia
			where "t"."idLekcji" > 0 AND "t"."idLekcji" <= (
				select * from (
					select "tu"."idLekcji" from "Tura" "tu"
					left join "Klasa" "k" ON "tu"."idKlasy" = "k"."id"
					left join "Uzytkownik" "u" ON "u"."idKlasy" = "k"."id"
					where "u"."id" = :idUcznia
					order by "tu"."idLekcji" desc
				)
				where rownum <= 1
			)
			connect by prior "t"."id" = "t"."idRodzica"
			start with "t"."idRodzica" is null
			order siblings by "t"."idLekcji" desc
		', array(':idUcznia' => $id));

		$akcje = array();
		foreach ($akcjeArr as $akcja)
			$akcje[$akcja->idLekcji][] = $akcja;

		$this->render('student',array(
			'model'=>$model,
			'akcje'=>$akcje
		));
	}

	public function actionCompany($id)
	{
		$model = Firma::getTeachersBusiness($id);

		if (empty($model))
			throw new CHttpException(404, 'Brak dostępu do firmy');

		$forms = Firma::model()->getForms($id);

		$this->render('company',array(
			'model'=>$model,
			'forms'=>$forms
		));
	}

	public function actionFormStatusChange($userFormId, $status)
	{
		if(!($status == FormularzUzytkownika::STATUS_ACCEPTED || $status == FormularzUzytkownika::STATUS_REFUSED))
			throw new CHttpException(404,'Nie można znaleźć podanej strony.');

		$model = FormularzUzytkownika::getTeacherUserForm($userFormId);

		if (empty($model))
			throw new CHttpException(404, 'Brak dostępu do formularza.');

		$model->status = $status;
		$model->save(false);

		if($status == FormularzUzytkownika::STATUS_ACCEPTED)
		{
			$fu = FormularzUzytkownika::model()->find(array(
				'condition' => '"id" = :ufid',
				'params' => array(':ufid' => $userFormId),
			));
			if(isset($fu))
			{
				$u = Uzytkownik::model()->find(array(
					'condition'=>'"id" = :uidd',
					'params' => array(':uidd'=>$fu->idUzytkownika),
				));

				// remove blockade if exists
				Akcja::removeSpecificAction("odrzuconyFormularz",$u->id);
				Akcja::removeSpecificAction("niezaakceptowaneFormularze",$u->id);

				switch($fu->idFormularza)
				{
					case 1:
						Akcja::saveSpecificActionAsUnread("wniosekZatwierdzony", $u);
					break;
					case 2:
						Akcja::saveSpecificActionAsUnread("zatwierdzenieCEIDG", $u);
					break;
					case 11:
						Akcja::saveSpecificActionAsUnread("poRejestracjiwZUS", $u);
					break;
					case 8:
						Akcja::saveSpecificActionAsUnread("zaakceptowanyVATR", $u); // infoPoVATR
					break;
				}

			}

		}
		else if($status == FormularzUzytkownika::STATUS_REFUSED)
		{
			$fu = FormularzUzytkownika::model()->find(array(
				'condition' => '"id" = :ufid',
				'params' => array(':ufid' => $userFormId),
			));
			if(isset($fu))
			{
				$u = Uzytkownik::model()->find(array(
					'condition'=>'"id" = :uidd',
					'params' => array(':uidd'=>$fu->idUzytkownika),
				));
				Akcja::removeSpecificAction("niezaakceptowaneFormularze",$u->id);
				Akcja::saveSpecificActionAsUnread("odrzuconyFormularz",$u);
			}
		}

		$statusMessage = 'Formularz "'.$model->formularz->nazwa.'" został ';
		$statusMessage .= $model->status==FormularzUzytkownika::STATUS_ACCEPTED?'zaakceptowany.':'odrzucony.';

		Yii::app()->user->setFlash('formStatusChanged',$statusMessage);

		$this->redirect(array('/teacher/main/documents') );
	}

	public function actionStatistics($classId=null,$companyId=null,$studentId=null)
	{
		if(!empty($classId))
		{
			$model = Klasa::getTeacherClass($classId);

			if(empty($model))
				throw new CHttpException(404, 'Brak dostępu do klasy.');

			$pointsDataProvider = Firma::model()->getAllStatisticsByTeacher($classId,Yii::app()->user->id);
			$userPointsDataProvider = Uzytkownik::model()->getAllStatistics($classId);

			$studentDataArray = array();
			$companyUserNames = array();

			foreach($userPointsDataProvider->data as $row)
			{
				if(!isset($companyUserNames[$row["idFirmy"]]))
					$companyUserNames[$row["idFirmy"]] = array($row["nazwisko"]." ".$row["imie"]);
				else
					$companyUserNames[$row["idFirmy"]][] = $row["nazwisko"]." ".$row["imie"];

				$studentDataArray[$row["imie"]." ".$row["nazwisko"]." ".$row["id"]] = $row["punkty"];
			}

			foreach($companyUserNames as $companyId=>$userNames)
				$companyUserNames[$companyId] = implode(', ', $companyUserNames[$companyId]);

			$companyDataArray = array();

			$pointsData = $pointsDataProvider->data;

			foreach($pointsData as &$row)
			{
				$row["nazwa"] = trim($row["nazwa"]);

				if(array_search($row["id"], $companyUserNames) !== false) {
					$row["nazwa"] = $companyUserNames[$row["id"]].(!empty($row["nazwa"]) ? ' ('.$row["nazwa"].')' : "");
				}

				$companyDataArray[$row["nazwa"]." ".$row["id"]] = $row["punkty"];
			}

			$pointsDataProvider->data = $pointsData;

			$this->render('statisticsClass',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'userPointsDataProvider'=>$userPointsDataProvider,
				'model'=>$model,
				'studentDataJsObject'=>CJavaScript::encode($studentDataArray),
				'companyDataJsObject'=>CJavaScript::encode($companyDataArray),
				'companyUserNames'=>$companyUserNames,
			));
		}
		else if(!empty($companyId))
		{
			$model = Firma::getTeachersBusiness($companyId);

			if (empty($model))
				throw new CHttpException(404, 'Brak dostępu do firmy.');

			$pointsDataProvider = $model->getStatistics();

			$dataArray = array();

			foreach($pointsDataProvider->data as $row)
				$dataArray[$row["nazwa"]] = $row["punkty"];

			$this->render('statisticsCompany',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'model'=>$model,
				'dataJsObject'=>CJavaScript::encode($dataArray)
			));
		}
		else if(!empty($studentId))
		{
			$model = Uzytkownik::getTeachersStudent($studentId);

			if (empty($model))
				throw new CHttpException(404, 'Brak dostępu do ucznia.');

			$pointsDataProvider = $model->getStatistics();

			$zleceniaDataProvider = $model->getZleceniaStatistics();

			$dataArray = array();

			foreach($pointsDataProvider->data as $row)
				$dataArray[$row["nazwa"]." ".$row["id"]] = $row["punkty"];

			$this->render('statisticsStudent',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'model'=>$model,
				'dataJsObject'=>CJavaScript::encode($dataArray),
				'zleceniaDataProvider'=>$zleceniaDataProvider
			));
		}
		else
		{
			$pointsDataProvider = Klasa::model()->getAllStatistics(Yii::app()->user->id);

			$dataArray = array();

			foreach($pointsDataProvider->data as $row)
				$dataArray[$row["klasa"].' '.$row["id"]] = $row["punkty"];

			$this->render('statistics',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'dataJsObject'=>CJavaScript::encode($dataArray)
			));
		}
	}

	public function actionImageTest()
	{
		Yii::import('application.modules.student.models.Form2');
		$model = new Form2();
		$userForm = FormularzUzytkownika::model()->findByPk(22);
		$model->find($userForm->idUzytkownika);

		foreach($model->pageUrls as $pageId=>$background)
		{
			$this->createImage('images/form-backgrounds/form'.$model->formId.'/'.$background, Yii::app()->user->id.'_'.$pageId.'_'.'.', $model, $pageId);
			break;
		}
	}

	public function actionGetMessages()
	{
		if(in_array($_POST['from'], array('documents','inactiveStudents','tenders')))
		{
			echo json_encode(array());
			return;
		}

		$messages = array();

		//checking inactive users
		$sql = '
			SELECT COUNT(*) FROM "AdminKlasy" ak
			LEFT JOIN "Firma" f ON ak."idKlasy" = f."idKlasy"
			LEFT JOIN "Uzytkownik" u ON u."idFirmy" = f."id"
			WHERE ak."idAdmina" = :teacherId AND f."status" = 0 AND u."status" = 0
		';

		$numberOfNonActiveUsers = Yii::app()->db->createCommand($sql)->queryScalar(array(
			':teacherId' => Yii::app()->user->id
		));
		if($numberOfNonActiveUsers)
			$messages[] = 'Masz '.$numberOfNonActiveUsers.' nieaktywnych uczniów w Twoich klasach. <a href="'.Yii::app()->createUrl('teacher/main/inactiveStudents').'">Kliknij tutaj</a>, aby aktywować lub usunąć.';

		//forms
		$sql = 'SELECT COUNT(*) FROM "FormularzUzytkownika" fu
			LEFT JOIN  "Uzytkownik" u ON u."id" = fu."idUzytkownika"
			LEFT JOIN "AdminKlasy" ak ON ak."idKlasy" = u."idKlasy"
			WHERE ak."idAdmina" = '.Yii::app()->user->id.' AND fu."status" IN ('.FormularzUzytkownika::STATUS_FILLED.')';

		$numberOfNewForms = Yii::app()->db->createCommand($sql)->queryScalar();

		if($numberOfNewForms)
			$messages[] = 'Masz '.$numberOfNewForms.' nowych formularzy do sprawdzenia. <a href="'.Yii::app()->createUrl('teacher/main/documents').'">Kliknij tutaj</a>, aby zaakceptować lub odrzucić.';

		$sql = 'SELECT COUNT(*) FROM "PrzetargGrupa" pg
			LEFT JOIN "PrzetargFirma" pf ON pg."id" = pf."idGrupy"
			LEFT JOIN "Firma" f ON f."id" = pf."idFirmy"
			WHERE f."idKlasy" IN (SELECT "idKlasy" FROM "AdminKlasy" WHERE "idAdmina" = '.Yii::app()->user->id.')
			AND pg."status" = '.PrzetargGrupa::TENDER_STATUS_ACCEPTATION_REQUEST.' AND pf."status" > 0';

		$notAcceptedOffers = Yii::app()->db->createCommand($sql)->queryScalar();

		if($notAcceptedOffers)
			$messages[] = 'Masz nowe przetargi do zatwierdzenia. <a href="'.Yii::app()->createUrl('teacher/main/tenders').'">Kliknij tutaj</a>, aby zatwierdzić.';

		echo json_encode($messages);
	}

	public function actionTenders($classId = null, $orderId = null)
	{
		Przetarg::initialize(Yii::app()->user->id);

		if(!empty($orderId) && !empty($classId))
		{
			$class = Klasa::getTeacherClass($classId);

			if (empty($class))
				throw new CHttpException(404, 'Brak dostępu do firmy');

			$tender = Przetarg::model()->with('kontrahent.dziedzina', 'grupy.firmy.firma', 'pendingGroups')->find(array(
				'condition' => '"t"."id" = :tenderId and "t"."idKlasy" = :classId',
				'params' => array(
					':classId' => $classId,
					':tenderId' => $orderId
				)
			));
			if (empty($tender))
				throw new CHttpException(404, 'Przetarg nie istnieje');
			if (!(int)$tender->pendingGroups)
				throw new CHttpException(404, 'Przetarg został już rozpatrzony.');

			$this->render('tendersOrder',array(
				'class'=>$class,
				'tender'=>$tender
			));
		}
		else if(!empty($classId))
		{
			$class = Klasa::getTeacherClass($classId);

			if (empty($class))
				throw new CHttpException(404, 'Brak dostępu do klasy.');

			//handle modifications
			if (isset($_POST['tenders']))
			{
				$postedTenders = $_POST['tenders'];
				foreach ($postedTenders as $tender)
				{
					if ($tender['status'] == 1)
					{
						$oldTender = Przetarg::model()->with('isInUse')->findByPk($tender['id']);
						if ($oldTender && !$oldTender->isInUse)
						{
							$oldTender->attributes = $tender;
							$oldTender->save();
						}
					}
					else if ($tender['status'] == 0)
					{
						$oldTender = Przetarg::model()->with('isInUse')->findByPk($tender['id']);
						if ($oldTender && !$oldTender->isInUse)
							$oldTender->delete();
					}
					else if ($tender['status'] == 2)
					{
						$newTender = new Przetarg;
						$newTender->attributes = $tender;
						$newTender->save();
					}
				}
			}

			$orders = Klasa::model()->getOrders($classId);

			$tenders = Przetarg::model()->with('akcja', 'kontrahent.dziedzina', 'isInUse')->findAll(array(
				'condition' => '"t"."idKlasy" = :classId',
				'params' => array(':classId' => $classId),
				'order' => '"akcja"."idLekcji", "akcja"."id", "kontrahent"."nazwa"',
			));

			$this->render('tenders',array(
				'orders'=>$orders,
				'class'=>$class,
				'tenders'=>$tenders
			));
		}
		else
		{
			$classes = new CActiveDataProvider('Klasa',array(
				'criteria'=>array(
					'condition'=>'"id" IN (SELECT "idKlasy" FROM "AdminKlasy" where "idAdmina" = '.Yii::app()->user->id.') AND  ("czyTestowa" = 0 OR "czyTestowa" = 1 AND "id" = (SELECT MAX("id") FROM "Klasa" LEFT JOIN "AdminKlasy" ON "AdminKlasy"."idKlasy" = "Klasa"."id" WHERE "AdminKlasy"."idAdmina" = '.Yii::app()->user->id.' AND "Klasa"."czyTestowa" = 1))',
				),
				'pagination'=>false
			));



			$this->render('tendersClasses',array(
				'classes'=>$classes
			));
		}
	}

	public function actionAcceptTender($groupId,$classId)
	{
		$grupa = PrzetargGrupa::getTeachersGroup($groupId, 'przetarg.kontrahent.dziedzina', 'firmy.firma.activeUsers');

		if (empty($grupa))
			throw new CHttpException(404, 'Brak dostępu do grupy');

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			$grupa->accept();

			$transaction->commit();

			Yii::app()->user->setFlash('success', 'Grupa została zaakceptowana.');
			$this->redirect(array('/teacher/main/tenders','classId'=>$classId));
		}
		catch (Exception $ex)
		{
			$transaction->rollback();
			Yii::app()->user->setFlash('error', $ex->getMessage());
			$this->redirect(array('/teacher/main/tenders','classId'=>$classId,'orderId'=>$groupId));
		}
	}

	public function actionUpdateOrder()
	{
		header('Content-type: text/json');
		$result = array();

		$taskId = filter_input(INPUT_POST, 'taskId', FILTER_VALIDATE_INT);
		$status = filter_input(INPUT_POST, 'status', FILTER_VALIDATE_BOOLEAN);

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//load zlecenie firmy nauczyciela
			$zlecenie = ZlecenieFirmy::model()->find(array(
				'join' => '
					left join "Firma" "f" ON "t"."idFirmy" = "f"."id"
					Left Join "AdminKlasy" "ak" On "ak"."idKlasy" = "f"."idKlasy"
				',
				'condition' => '"t"."id" = :taskId AND "ak"."idAdmina" = :teacherId',
				'params' => array(
					':taskId' => $taskId,
					':teacherId' => Yii::app()->user->id
				),
				'with' => array('faktura', 'oplata', 'idFirmy0', 'idZlecenia0')
			));
			if (empty($zlecenie))
				throw new Exception('Nie ma zlecenia bądź nie masz do niego uprawnień.');

			if (!$zlecenie->isFinished)
				throw new Exception('Nie można zmienić stanu zlecenia które nadal trwa.');

			if (!empty($zlecenie->idGrupyPrzetargowej))
				throw new Exception('Nie można zmienić statusu zleceniu przypisanego do przetargu.');

			//zaktualizuj zlecenie
			if ($status)
			{
				$changed = empty($zlecenie->idOdpowiedzi);
				if ($changed)
					$zlecenie->accept();
			}
			else
			{
				$changed = !empty($zlecenie->idOdpowiedzi);
				if ($changed)
					$zlecenie->refuse();
			}

			if ($changed)
			{
				if (!$zlecenie->save())
					throw new Exception('Nie można zaktualizować zlecenia.');

				//dodaj do loga
				$log = new ZlecenieFirmyLog;
				$log->idAdmina = Yii::app()->user->id;
				$log->idZlecenieFirmy = $zlecenie->id;
				$log->data = new CDbExpression('SYSDATE');
				$log->status = $status ? '1' : '0';
				if (!$log->save())
					throw new Exception('Nie można zanotować akcji w dzienniku.');
			}

			$transaction->commit();

			$result['ok'] = true;
		}
		catch (Exception $e)
		{
			$transaction->rollback();
			$result['error'] = $e->getMessage();
		}

		echo json_encode($result);
		Yii::app()->end();
	}

	public function actionMarkStudentPresence()
	{
		header('Content-type: text/json; charset=utf-8');
		$result = array();

		try
		{
			$studentId = filter_input(INPUT_POST, 'studentId', FILTER_VALIDATE_INT);
			$present = filter_input(INPUT_POST, 'present', FILTER_VALIDATE_INT);

			$user = Uzytkownik::model()->find(array(
				'condition' => '"t"."id" = :studentId and ak."idAdmina" = :teacherId',
				'join' => 'left join "AdminKlasy" ak on ak."idKlasy" = "t"."idKlasy"',
				'params' => array(
					':studentId' => $studentId,
					':teacherId' => Yii::app()->user->id
				)
			));
			if (empty($user))
				throw new Exception('Brak dostępu do użytkownika.');

			$tura = Tura::getTuraForClass($user->idKlasy);
			if (empty($tura))
				throw new Exception('Nie rozpoczęto jeszcze żadnej lekcji.');

			if (strtotime($tura->czasZakonczenia) < time())
				throw new Exception('Lekcja została już zakończona.');

			$log = UzytkownikObecnosc::model()->findByAttributes(array(
				'idUzytkownika' => $studentId,
				'idTury' => $tura->id
			));
			if (empty($log))
			{
				$log = new UzytkownikObecnosc;
				$log->idTury = $tura->id;
				$log->idUzytkownika = $studentId;
			}
			$log->obecny = $present ? 1 : 0;
			$log->save();

			$result['present'] = $present;
		}
		catch(Exception $e)
		{
			$result['error'] = $e->getMessage();
		}

		echo json_encode($result);
		Yii::app()->end();
	}
	
	public function actionCancelLesson($id, $classId)
	{
		$classModel = Klasa::model()->with(array('uzytkowniks'=>array('select'=>"dataLogowania", 'order'=>'"dataLogowania" DESC')))->findByPk($classId);
		$lessonModel = Lekcja::model()->findByPk($id);
		$turaModel = Tura::model()->findByAttributes(array('idKlasy'=>$classId, 'idLekcji'=>$id));

		$cancelAllowed = $turaModel->checkIfCancelAllowed();

		if(isset($_POST['accept']))
		{
			if($cancelAllowed)
			{
				$turaModel->delete();
				Yii::app()->user->setFlash('lessonCancelled','Lekcja <b>'.$id.'</b> dla klasy <b>'.$classModel->nazwa.'</b> została anulowana.');
				$this->redirect(array('index'));
			}
			else
				Yii::app()->user->setFlash('error','Nie możesz anulować obecnej lekcji, ponieważ minęło już 10 minut od jej rozpoczęcia lub co najmniej jeden uczeń się zalogował.');
		}
		
		$this->render('cancelLesson',array(
			'lessonModel'=>$lessonModel,
			'classModel'=>$classModel,
			'cancelAllowed'=>$cancelAllowed,
		));
	}
}
